IF OBJECT_ID('P_CONSULTA_CEP_POR_FILIAL') IS NOT NULL
BEGIN
	DROP PROCEDURE P_CONSULTA_CEP_POR_FILIAL
END

GO

CREATE PROCEDURE 
	P_CONSULTA_CEP_POR_FILIAL (@CEP VARCHAR(8))
AS
BEGIN

DECLARE @CEP_FILIAL TABLE (
	CD_FILIAL INT,
	CEP_INI VARCHAR(8),
	CEP_FIM VARCHAR(8),
	ORDEM INT)

INSERT INTO
	@CEP_FILIAL
SELECT 
	PRC_FILIAL_GLB_CID_LOGRA.CD_FILIAL,
	MIN(GLB_CID_LOGRA.CEP),
	MAX(GLB_CID_LOGRA.CEP),
	PRC_FILIAL_GLB_CID_LOGRA.ORDEM
FROM 
	PRC_FILIAL_GLB_CID_LOGRA
	INNER JOIN GLB_CID_LOGRA ON
		PRC_FILIAL_GLB_CID_LOGRA.CD_LOGRA = GLB_CID_LOGRA.CD_CID_LOGRA
	INNER JOIN GLB_CID ON
		GLB_CID_LOGRA.CD_CID = GLB_CID.CD_CID
GROUP BY
	PRC_FILIAL_GLB_CID_LOGRA.CD_FILIAL,
	PRC_FILIAL_GLB_CID_LOGRA.ORDEM


SELECT TOP 2
	'Filial' + RIGHT('000' + CAST(F.CD_FILIAL AS VARCHAR), 3),
	F.NM_FANT
FROM 
	@CEP_FILIAL C
	INNER JOIN PRC_FILIAL F ON
		C.CD_FILIAL = F.CD_FILIAL
WHERE
	@CEP BETWEEN CEP_INI AND CEP_FIM
ORDER BY
	ORDEM

END